(function($) { 'use strict';
	// Calculate clients viewport
	const w = window,
	d = document,
	e = d.documentElement,
	g = d.getElementsByTagName('body')[0];

	let x = w.innerWidth || e.clientWidth || g.clientWidth, // Viewport Width
	y = w.innerHeight || e.clientHeight || g.clientHeight; // Viewport Height

	// Global vars
	const htmlEl = document.documentElement;
	const body = document.body;
	let htmlOffsetTop = parseInt(window.getComputedStyle(htmlEl).marginTop);

	$(function(){

		// On scroll
		const fnOnScroll = function(){
			const animateBlock = $('.h-animate--from-top, .h-animate--from-left, .h-animate--from-right, .h-animate--from-bottom, .js-reveal--from-top, .js-reveal--from-bottom, .h-reveal--images--from-bottom, .wp-block-separator, .products > .product, .wc-block-grid__products .wc-block-grid__product');

			animateBlock.removeClass('is-loading');

			animateBlock.each(function(){
				const $this = $(this);
				const animateBlockOffsetTop = $this.offset().top;
				let activationOffset;

				// Determinate distance to initiate animation relative to viewport height - add date-offset attribute to animating element. Default is date-offset="1.2"
				if($this.data('offset'))
					activationOffset = $this.data('offset');
				else if($this.hasClass('h-reveal--images--from-bottom'))
					activationOffset = 1.8;
				else if($this.hasClass('product'))
					activationOffset = 1.05;
				else
					activationOffset = 1.2;

				if((window.pageYOffset > animateBlockOffsetTop - y / activationOffset)){
					$this.addClass('scrolled-to');
				}
			});
		};

		fnOnScroll();

		window.onscroll = function() {
			setTimeout(function(){
				fnOnScroll();
			},300);
		};

		// Add Show class to body
		body.classList.add('show');

	}); // End Document Ready


})(jQuery);