<?php
if ( ! function_exists( 'furnizo_support' ) ) :
	function furnizo_support() {

		// Load Theme Textdomain
		load_theme_textdomain( 'furnizo', get_template_directory() . '/languages' );
		if ( ! 'furnizo' === wp_get_theme()->get( 'TextDomain' ) ) {
			load_theme_textdomain( wp_get_theme()->get( 'TextDomain' ) );
		}

		// Adds custom classes to the array of body classes.
		function furnizo_body_classes( $classes ) {
			// Adds a class of tk-theme-frontend when viewing frontend.
			if ( !is_admin() ) {
				$classes[] = esc_attr( 'tk-theme-frontend' );
			}
			return $classes;
		}
		add_filter( 'body_class', 'furnizo_body_classes' );

		// Alignwide and alignfull classes in the block editor.
		add_theme_support( 'align-wide' );

		// Add support for experimental link color control.
		add_theme_support( 'experimental-link-color' );

		// Add support for responsive embedded content.
		// https://github.com/WordPress/gutenberg/issues/26901
		add_theme_support( 'responsive-embeds' );

		// Add margin to blocks
		add_theme_support( 'custom-spacing' );

		// Add support for editor styles.
		add_theme_support( 'editor-styles' );

		// Add support for post thumbnails.
		add_theme_support( 'post-thumbnails' );

		// Add filter for disable srcset on frontend (img)
		add_filter( 'wp_calculate_image_srcset', '__return_false' );
		add_filter( 'wp_calculate_image_srcset_meta', '__return_false' );

		// Experimental support for adding blocks inside nav menus
		add_theme_support( 'block-nav-menus' );

		// Enqueue editor styles.
		add_editor_style(
			array(
				'/assets/ponyfill.css',
			)
		);

		// Register nav menus if Gutenberg is activated (otherwise the __experimentalMenuLocation attribute isn't available)
		register_nav_menus(
			array(
				'primary' => __( 'Primary Navigation', 'furnizo' ),
			)
		);

		// Woocommerce
		add_theme_support( 'woocommerce');

	}
	add_action( 'after_setup_theme', 'furnizo_support' );
endif;

/**
 *
 * Add borderless button to buttons block
 */
register_block_style(
	'core/button',
		array(
			'name'  => 'button-borderless',
			'label' => __( 'Borderless', 'furnizo' )
		)
);

/**
 *
 * Enqueue scripts and styles.
 */
function TK_furnizo_editor_styles() {
	// Add the child theme CSS if it exists.
	if ( file_exists( get_stylesheet_directory() . '/assets/theme.css' ) ) {
		add_editor_style(
			'/assets/theme.css'
		);
	}
}
add_action( 'admin_init', 'TK_furnizo_editor_styles' );

/**
 *
 * Enqueue scripts and styles.
 */
function TK_furnizo_register_scripts() {

	wp_enqueue_style( 'furnizo-main', get_template_directory_uri() . '/assets/css/main.css', array(), wp_get_theme()->get( 'Version' ) );

	wp_enqueue_style( 'furnizo-animation', get_template_directory_uri() . '/assets/css/animation.css', array(), wp_get_theme()->get( 'Version' ) );

	wp_enqueue_style( 'furnizo-styles', get_template_directory_uri() . '/assets/css/styles.css', array(), wp_get_theme()->get( 'Version' ) );
	
	if ( is_rtl() ) {
		wp_enqueue_style( 'furnizo-rtl-style', get_template_directory_uri() . '/assets/rtl.css', array(), wp_get_theme()->get( 'Version' ) );
	}

	// Dashicons on frontend
	wp_enqueue_style( 'dashicons' );

	if ( is_product() ) {
		// Slick
		wp_enqueue_style( 'furnizo-slick', get_template_directory_uri() . '/assets/slick/slick.css', array(), wp_get_theme()->get( 'Version' ) );
		wp_enqueue_script( 'furnizo-slick', get_template_directory_uri() . '/assets/slick/slick.min.js', array( 'jquery' ), wp_get_theme()->get( 'Version' ), true );
	}

	// Scripts
	wp_enqueue_script( 'furnizo-call-scripts', get_template_directory_uri() . '/assets/js/common.js', array( 'jquery' ), wp_get_theme()->get( 'Version' ), true );

}
add_action( 'wp_enqueue_scripts', 'TK_furnizo_register_scripts' );

// Customize Global Styles

if ( class_exists( 'WP_Theme_JSON_Resolver' ) ) {
	require get_template_directory() . '/inc/customizer/wp-customize-colors.php';
}

//require get_template_directory() . '/inc/fonts/custom-fonts.php';


// Block Patterns.
require get_template_directory() . '/inc/block-patterns.php';

// Add the child theme patterns if they exist.
if ( file_exists( get_stylesheet_directory() . '/inc/block-patterns.php' ) ) {
	require_once get_stylesheet_directory() . '/inc/block-patterns.php';
}

// Add column: Product type
add_filter( 'manage_edit-product_columns', 'furnizo_admin_products_visibility_column');

function furnizo_admin_products_visibility_column( $columns ){
	$columns['product_type'] = 'Type';
	return $columns;
}

add_action( 'manage_product_posts_furnizo_column', 'furnizo_admin_products_visibility_column_content', 20, 2 );

function furnizo_admin_products_visibility_column_content( $column, $product_id ){
    if ( $column == 'product_type' ) {
        $product = wc_get_product( $product_id );
        $product_type = $product->get_type();
        echo ucfirst( $product_type );
    }
}

// Product Featured Image - Checkout Page Order Review Table
add_filter( 'woocommerce_cart_item_name', 'furnizo_product_image_review_order_checkout', 9999, 3 );

function furnizo_product_image_review_order_checkout( $name, $cart_item, $cart_item_key ) {
    if ( ! is_checkout() ) return $name;
    $product = $cart_item['data'];
    $thumbnail = $product->get_image( array( '50', '50' ), array( 'class' => 'alignleft' ) );
    return $thumbnail . $name;
}

// Product Gallery Thumbnail Carousel
remove_action( 'woocommerce_product_thumbnails', 'woocommerce_show_product_thumbnails', 20 );
add_action( 'woocommerce_product_thumbnails', 'furnizo_woocommerce_show_product_thumbnails', 20 );
function furnizo_woocommerce_show_product_thumbnails(){
	global $product;
	$attachment_ids = $product->get_gallery_image_ids();

	//$product_view = 'vertical';
	//$class = "furnizo_vertical_slider";

	//$product_view = 'horizontal';
	//$class = "furnizo_horizontal_slider";

	$product_view = 'vertical';
	if($product_view == 'vertical'){
		$class="furnizo_vertical_slider";
	}

	add_action('wp_footer', 'woo_single_page_furnizo_javascript_slider');
	add_action('wp_head', 'woo_single_page_furnizo_css');

	if ( $attachment_ids && $product->get_image_id() ) {
		
		$bottom__sliderhtml = '';

		foreach ( $attachment_ids as $attachment_id ) {
			$gallery_thumbnail = wc_get_image_size( 'gallery_thumbnail' );
			$thumbnail_size    = apply_filters( 'woocommerce_gallery_thumbnail_size', array( $gallery_thumbnail['width'], $gallery_thumbnail['height'] ) );
			$thumbnail_src     = wp_get_attachment_image_src( $attachment_id, $thumbnail_size );
			$full_src          = wp_get_attachment_image_src( $attachment_id,'full');
			$image_full  = wp_get_attachment_image($attachment_id,'full',false,apply_filters('woocommerce_gallery_image_html_attachment_image_params',
					array(
						'title'                   => _wp_specialchars( get_post_field( 'post_title', $attachment_id ), ENT_QUOTES, 'UTF-8', true ),
						'data-caption'            => _wp_specialchars( get_post_field( 'post_excerpt', $attachment_id ), ENT_QUOTES, 'UTF-8', true ),
						'data-src'                => esc_url( $full_src[0] ),
						'data-large_image'        => esc_url( $full_src[0] ),
						'data-large_image_width'  => esc_attr( $full_src[1] ),
						'data-large_image_height' => esc_attr( $full_src[2] ),
						'class'                   => esc_attr( 'wp-post-image' ),
					),$attachment_id,'full',false)
			);
			$image = wp_get_attachment_image($attachment_id,$thumbnail_size,false,apply_filters('woocommerce_gallery_image_html_attachment_image_params',
					array(
						'title'                   => _wp_specialchars( get_post_field( 'post_title', $attachment_id ), ENT_QUOTES, 'UTF-8', true ),
						'data-caption'            => _wp_specialchars( get_post_field( 'post_excerpt', $attachment_id ), ENT_QUOTES, 'UTF-8', true ),
						'data-src'                => esc_url( $full_src[0] ),
						'data-large_image'        => esc_url( $full_src[0] ),
						'data-large_image_width'  => esc_attr( $full_src[1] ),
						'data-large_image_height' => esc_attr( $full_src[2] ),
						'data-full_img_data'	=> $image_full,
						'class'                   => esc_attr( 'furnizo_gallery__image_swiper_thumbnail' ),
					),$attachment_id,$thumbnail_size,false)
			);
		
			$bottom__sliderhtml .= '<div class="woocommerce-product-furnizo_gallery__image swiper-slide">' . $image . '</div>';
		}
	echo '<div thumbsSlider="" class="swiper mySwiper '.$class.'">
				<div class="swiper-wrapper">
				'.$bottom__sliderhtml.'
				</div>
				<div class="swiper-button-prev"></div>
				<div class="swiper-button-next"></div>
			</div>';
		if($product_view == 'vertical'){
			echo '<style>
			.woocommerce-product-gallery__wrapper {
				display: flex;
				flex-direction: row-reverse;
			}
			.woocommerce-product-gallery__image {
				width: 75%;
			}</style>';
		}
	}

}
function wc_get_gallery_image_html_custom( $attachment_id, $main_image = false ) {
	$flexslider        = (bool) apply_filters( 'woocommerce_single_product_flexslider_enabled', get_theme_support( 'wc-product-gallery-slider' ) );
	$gallery_thumbnail = wc_get_image_size( 'gallery_thumbnail' );
	$thumbnail_size    = apply_filters( 'woocommerce_gallery_thumbnail_size', array( $gallery_thumbnail['width'], $gallery_thumbnail['height'] ) );
	$image_size        = apply_filters( 'woocommerce_gallery_image_size', $flexslider || $main_image ? 'woocommerce_single' : $thumbnail_size );
	$full_size         = apply_filters( 'woocommerce_gallery_full_size', apply_filters( 'woocommerce_product_thumbnails_large_size', 'full' ) );
	$thumbnail_src     = wp_get_attachment_image_src( $attachment_id, $thumbnail_size );
	$full_src          = wp_get_attachment_image_src( $attachment_id, $full_size );
	$alt_text          = trim( wp_strip_all_tags( get_post_meta( $attachment_id, '_wp_attachment_image_alt', true ) ) );
	$image             = wp_get_attachment_image(
		$attachment_id,
		$image_size,
		false,
		apply_filters(
			'woocommerce_gallery_image_html_attachment_image_params',
			array(
				'title'                   => _wp_specialchars( get_post_field( 'post_title', $attachment_id ), ENT_QUOTES, 'UTF-8', true ),
				'data-caption'            => _wp_specialchars( get_post_field( 'post_excerpt', $attachment_id ), ENT_QUOTES, 'UTF-8', true ),
				'data-src'                => esc_url( $full_src[0] ),
				'data-large_image'        => esc_url( $full_src[0] ),
				'data-large_image_width'  => esc_attr( $full_src[1] ),
				'data-large_image_height' => esc_attr( $full_src[2] ),
				'class'                   => esc_attr( $main_image ? 'wp-post-image' : '' ),
			),
			$attachment_id,
			$image_size,
			$main_image
		)
	);

	return '<div data-thumb="' . esc_url( $thumbnail_src[0] ) . '" data-thumb-alt="' . esc_attr( $alt_text ) . '" class="woocommerce-product-gallery__image"><a href="' . esc_url( $full_src[0] ) . '">' . $image . '</a></div>';
}
function woo_single_page_furnizo_css(){
    ?>
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
        <style>
			.furnizo_vertical_slider {
				width: 100%;
				height: 100%;
				width: 20%;
				height: 730px;
				margin-left: auto;
				margin-right: auto;
				box-sizing: border-box;
			}
			.furnizo_vertical_slider .swiper-slide img {
				display: block;
				width: 100%;
				height: inherit !important;
			}
			.furnizo_vertical_slider .swiper-slide {
				display: flex;
				padding: 0 0 0 0;
				justify-content: center;
				align-items: center;
				background-size: cover;
				background-position: center;
				width: 100%;
				height: 100%;
				opacity: 1;
			}
			.furnizo_vertical_slider .swiper-slide-thumb-active {
				opacity: 1;
			}
			.furnizo_horizontal_slider {
				width: 100%;
				height: 20%;
				box-sizing: border-box;
				padding: 10px 0;
			}

			.furnizo_horizontal_slider .swiper-slide {
				text-align: center;
				font-size: 18px;
				background: #fff;
				display: flex;
				justify-content: center;
				align-items: center;
				background-size: cover;
				background-position: center;
				width: 25%;
				height: 100%;
				opacity: 1;
			}
			.furnizo_horizontal_slider .swiper-slide img {
				display: block;
				width: 100%;
				height: 100%;
				object-fit: cover;
			}
			.furnizo_horizontal_slider .swiper-slide-thumb-active {
				opacity: 1;
			}
			.furnizo_horizontal_slider .swiper-button-prev::after, 
			.furnizo_horizontal_slider .swiper-button-next::after,
			.furnizo_vertical_slider .swiper-button-prev::after, 
			.furnizo_vertical_slider .swiper-button-next::after {
				font-size: 30px;
				color: #000000;
			}
			.furnizo_horizontal_slider .swiper-button-next,.furnizo_horizontal_slider .swiper-button-prev {
				transform: translateY(-50%);
			}
		</style>
    <?php
}
function woo_single_page_furnizo_javascript_slider() {
    ?>
		<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
        <script>
			var swiper = new Swiper(".furnizo_horizontal_slider", {
				loop: false,
				spaceBetween: 20,
				slidesPerView: 4,
				freeMode: true,
				centeredSlides: true,
				centeredSlidesBounds: true,
				watchSlidesProgress: true,
				navigation: {
					nextEl: ".swiper-button-next",
					prevEl: ".swiper-button-prev",
				},
			});
			swiper.on('transitionStart', function(){
				$imgurl = jQuery('div.swiper-wrapper .swiper-slide:nth-child('+swiper.activeIndex+') img').data('large_image');
				$fullimghtml = jQuery('div.swiper-wrapper .swiper-slide:nth-child('+swiper.activeIndex+') img').data('full_img_data');
				jQuery(".woocommerce-product-gallery__wrapper a").html($fullimghtml);
				jQuery(".woocommerce-product-gallery__wrapper a").attr('href',$imgurl);
				jQuery(".woocommerce-product-gallery__wrapper img.zoomImg").attr("src",$imgurl);
			});
			var swiper11 = new Swiper(".furnizo_vertical_slider", {
				loop: false,
				spaceBetween: 20,
				slidesPerView: 6,
				freeMode: true,
				centeredSlides: false,
				centeredSlidesBounds: true,
				watchSlidesProgress: true,
				direction: 'vertical',
				navigation: {
					nextEl: ".swiper-button-next",
					prevEl: ".swiper-button-prev",
				},
			});
			swiper11.on('transitionStart', function(){
				$imgurl = jQuery('div.swiper-wrapper .swiper-slide:nth-child('+swiper.activeIndex+') img').data('large_image');
				$fullimghtml = jQuery('div.swiper-wrapper .swiper-slide:nth-child('+swiper.activeIndex+') img').data('full_img_data');
				jQuery(".woocommerce-product-gallery__wrapper a").html($fullimghtml);
				jQuery(".woocommerce-product-gallery__wrapper a").attr('href',$imgurl);
				jQuery(".woocommerce-product-gallery__wrapper img.zoomImg").attr("src",$imgurl);
			});
			jQuery('document').ready(function($){
				$(".furnizo_gallery__image_swiper_thumbnail").click(function(){
					$imgurl = $(this).data('large_image');
					$fullimghtml = $(this).data('full_img_data');
					$(".woocommerce-product-gallery__wrapper img.zoomImg").attr("src",$imgurl);
					$(".woocommerce-product-gallery__wrapper a").html($fullimghtml);
				});
			});
			
		</script>
    <?php
}