<?php
/**
 * Block Patterns
 *
 * @package furnizo
 * @since 1.0
 */

/**
 * Register Block Pattern Category.
 */
if ( function_exists( 'register_block_pattern_category' ) ) {

	register_block_pattern_category(
		'tk-text',
		array( 'label' => _x( 'TK text', 'Text pattern category', 'furnizo' ) )
	);

	register_block_pattern_category(
		'tk-contact',
		array( 'label' => _x( 'TK contact', 'Contact pattern category', 'furnizo' ) )
	);

	register_block_pattern_category(
		'tk-about',
		array( 'label' => _x( 'TK about', 'About pattern category', 'furnizo' ) )
	);

	register_block_pattern_category(
		'tk-testimonial',
		array( 'label' => _x( 'TK testimonials', 'Testimonials pattern category', 'furnizo' ) )
	);

	register_block_pattern_category(
		'tk-gallery',
		array( 'label' => _x( 'TK gallery', 'Gallery pattern category', 'furnizo' ) )
	);

	register_block_pattern_category(
		'tk-headers',
		array( 'label' => _x( 'TK headers', 'Headers pattern category', 'furnizo' ) )
	);

	register_block_pattern_category(
		'tk-call-to-action',
		array( 'label' => _x( 'TK call to action', 'Call to action pattern category', 'furnizo' ) )
	);

}

/**
 * Register Block Patterns.
 */
if ( function_exists( 'register_block_pattern' ) ) {

	// Text
	register_block_pattern(
		'tk/text-1',
		array(
			'title'       => __( 'Intro with two columns', 'furnizo' ),
			'description' => esc_html_x( 'Heading with text in two columns.', 'Block pattern description', 'furnizo' ),
			'viewportWidth' => 1920,
			'categories' => array('tk-text'),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"backgroundColor\":\"background\",\"className\":\"l-no-margin-top\",\"layout\":{\"inherit\":true}} -->\n<div class=\"wp-block-group alignfull l-no-margin-top has-background-background-color has-background\"><!-- wp:spacer {\"height\":\"200px\"} -->\n<div style=\"height:200px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\",\"className\":\"l-no-margin-top\"} -->\n<div class=\"wp-block-group alignwide l-no-margin-top\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"style\":{\"typography\":{\"lineHeight\":\"1.3\",\"letterSpacing\":\"-1px\"}},\"fontSize\":\"large\"} -->\n<h2 class=\"has-large-font-size\" style=\"letter-spacing:-1px;line-height:1.3\">A headline's purpose is to quickly and briefly draw attention to the story. It is generally written by a&nbsp;copy editor, but may also be written by the writer, the page layout designer, or other editors. The most important story on the front page&nbsp;above the fold&nbsp;may have a larger headline if the story is unusually important.</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"50px\"} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#00000012\"}},\"className\":\"is-style-wide\"} -->\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background is-style-wide\" style=\"background-color:#00000012;color:#00000012\"/>\n<!-- /wp:separator -->\n\n<!-- wp:spacer {\"height\":\"20px\"} -->\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"right\":\"5vw\"}}}} -->\n<div class=\"wp-block-column\" style=\"padding-right:5vw\"><!-- wp:paragraph {\"style\":{\"typography\":{\"lineHeight\":\"1.6\"}}} -->\n<p style=\"line-height:1.6\">A paragraph (from the Ancient Greek παράγραφος, parágraphos, “to write beside”) is a self-contained unit of discourse in writing dealing with a particular point or idea. Though not required by the syntax of any language, paragraphs are usually an expected part of formal writing, used to organize longer prose.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"10px\"} -->\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph {\"backgroundColor\":\"background\",\"fontSize\":\"tiny\"} -->\n<p class=\"has-background-background-color has-background has-tiny-font-size\"><strong>Edwin Herbert Lewis (1894)</strong><br>The History of the Paragraph</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"style\":{\"spacing\":{\"padding\":{\"right\":\"5vw\"}}}} -->\n<div class=\"wp-block-column\" style=\"padding-right:5vw\"><!-- wp:paragraph {\"style\":{\"typography\":{\"lineHeight\":\"1.6\"}}} -->\n<p style=\"line-height:1.6\">In word processing and desktop publishing, a hard return or paragraph break indicates a new paragraph, to be distinguished from the soft return at the end of a line internal to a paragraph. This distinction allows word wrap to automatically re-flow text as it is edited, without losing paragraph breaks. </p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"10px\"} -->\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph {\"fontSize\":\"tiny\"} -->\n<p class=\"has-tiny-font-size\"><strong>Bringhurst, Robert (2005)</strong><br>The Elements of Typographic Style</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"10vw\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:10vw\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"200px\"} -->\n<div style=\"height:200px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->",
		)
	);

	// Contact
	register_block_pattern(
		'tk/contact-1',
		array(
			'title'       => __( 'Email link with social icons1', 'furnizo' ),
			'description' => esc_html_x( 'Large text with an email link and social icons.', 'Block pattern description', 'furnizo' ),
			'viewportWidth' => 1920,
			'categories' => array('tk-contact'),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"backgroundColor\":\"background\",\"className\":\"l-no-margin-top\",\"layout\":{\"inherit\":true}} -->\n<div class=\"wp-block-group alignfull l-no-margin-top has-background-background-color has-background\"><!-- wp:spacer {\"height\":\"120px\"} -->\n<div style=\"height:120px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"contentSize\":\"\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"typography\":{\"lineHeight\":\"1.2\"}},\"fontSize\":\"larger\"} -->\n<h2 class=\"has-text-align-center has-larger-font-size\" style=\"line-height:1.2\">Got questions?<br><a href=\"#\">Feel free to reach out</a>.</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"50px\"} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"500\"}},\"textColor\":\"secondary\",\"fontSize\":\"tiny\"} -->\n<p class=\"has-text-align-center has-secondary-color has-text-color has-tiny-font-size\" style=\"font-style:normal;font-weight:500\">FOLLOW US ON:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:social-links {\"iconColor\":\"primary\",\"iconColorValue\":\"#333333\",\"size\":\"has-normal-icon-size\",\"align\":\"center\",\"className\":\"items-justified-center is-style-logos-only\",\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\"}} -->\n<ul class=\"wp-block-social-links aligncenter has-normal-icon-size has-icon-color items-justified-center is-style-logos-only\"><!-- wp:social-link {\"url\":\"#\",\"service\":\"twitter\"} /-->\n\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"facebook\"} /-->\n\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"instagram\"} /-->\n\n<!-- wp:social-link {\"url\":\"#\",\"service\":\"pinterest\"} /--></ul>\n<!-- /wp:social-links --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"150px\"} -->\n<div style=\"height:150px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->",
		)
	);

	// About
	register_block_pattern(
		'tk/about-1',
		array(
			'title'       => __( 'Full-screen section with image and text', 'furnizo' ),
			'description' => esc_html_x( 'Full-screen section in two columns with single image and text. ', 'Block pattern description', 'furnizo' ),
			'viewportWidth' => 1920,
			'categories' => array('tk-about'),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"backgroundColor\":\"background\",\"className\":\"l-no-margin-top\",\"layout\":{\"inherit\":true}} -->\n<div class=\"wp-block-group alignfull l-no-margin-top has-background-background-color has-background\"><!-- wp:spacer {\"height\":\"120px\"} -->\n<div style=\"height:120px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\"} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:media-text {\"mediaId\":691,\"mediaLink\":\"https://nuptia-copy.tkdemos.co/patterns-about/image-14/\",\"mediaType\":\"image\",\"mediaWidth\":42,\"imageFill\":false} -->\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile\" style=\"grid-template-columns:42% auto\"><figure class=\"wp-block-media-text__media\"><img src=\"https://block-patterns.s3.eu-west-1.amazonaws.com/images/image-14.png\" alt=\"\" class=\"wp-image-691 size-full\"/></figure><div class=\"wp-block-media-text__content\"><!-- wp:group {\"style\":{\"spacing\":{\"padding\":{\"left\":\"3vw\",\"right\":\"1vw\"}}}} -->\n<div class=\"wp-block-group\" style=\"padding-right:1vw;padding-left:3vw\"><!-- wp:paragraph {\"placeholder\":\"Content…\",\"style\":{\"typography\":{\"fontStyle\":\"normal\",\"fontWeight\":\"500\",\"textTransform\":\"uppercase\"}},\"fontSize\":\"tiny\"} -->\n<p class=\"has-tiny-font-size\" style=\"font-style:normal;font-weight:500;text-transform:uppercase\">About me</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"10px\"} -->\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"style\":{\"typography\":{\"lineHeight\":\"1.2\",\"letterSpacing\":\"-1px\"}},\"fontSize\":\"extra-large\"} -->\n<h2 class=\"has-extra-large-font-size\" style=\"letter-spacing:-1px;line-height:1.2\">I am a New York-based model, represented by JAB Models in the USA and One Model in Europe.</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"10px\"} -->\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:spacer {\"height\":\"40px\"} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph {\"style\":{\"typography\":{\"lineHeight\":1.6}}} -->\n<p style=\"line-height:1.6\">Ever since Heart moved from Allentown, Pennsylvania to New York City, when she was just five years old, she was amazed by the edgy, New York fashion and style. She dreamt of having the closet of the most popular, “it” girls and walking the runaways for the world-known designers. When she was just 13 years old, her dreams came true</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"20px\"} -->\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:spacer {\"height\":\"30px\"} -->\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:paragraph -->\n<p><strong>Follow me on:</strong><br>Twitter<kbd> </kbd>   Facebook<meta charset=\"utf-8\"><kbd> </kbd>   Instagram</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:group --></div></div>\n<!-- /wp:media-text --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"150px\"} -->\n<div style=\"height:150px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->",
		)
	);

	// Testimonial
	register_block_pattern(
		'tk/testimonial-1',
		array(
			'title'       => __( 'Full-screen testimonial', 'furnizo' ),
			'description' => esc_html_x( 'Single, full-screen testimonial', 'Block pattern description', 'furnizo' ),
			'viewportWidth' => 1920,
			'categories' => array('tk-testimonial'),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"backgroundColor\":\"background\",\"layout\":{\"inherit\":true}} -->\n<div class=\"wp-block-group alignfull has-background-background-color has-background\"><!-- wp:spacer {\"height\":\"120px\"} -->\n<div style=\"height:120px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"full\",\"layout\":{\"contentSize\":\"840px\"}} -->\n<div class=\"wp-block-group alignfull\"><!-- wp:heading {\"textAlign\":\"center\",\"align\":\"wide\",\"fontSize\":\"larger\"} -->\n<h2 class=\"alignwide has-text-align-center has-larger-font-size\">Meet Our Happy Clients</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"10px\"} -->\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:spacer {\"height\":\"20px\"} -->\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#00000012\"}},\"className\":\"is-style-wide\"} -->\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background is-style-wide\" style=\"background-color:#00000012;color:#00000012\"/>\n<!-- /wp:separator -->\n\n<!-- wp:spacer {\"height\":\"50px\"} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:spacer {\"height\":\"30px\"} -->\n<div style=\"height:30px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"typography\":{\"fontSize\":\"200px\",\"lineHeight\":\"0.1\"},\"color\":{\"text\":\"#00000012\"}}} -->\n<h2 class=\"has-text-align-center has-text-color\" style=\"color:#00000012;font-size:200px;line-height:0.1\">”</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"100%\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"4vw\",\"left\":\"4vw\"}}}} -->\n<div class=\"wp-block-column\" style=\"padding-right:4vw;padding-left:4vw;flex-basis:100%\"><!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"typography\":{\"lineHeight\":\"1.3\"}},\"fontSize\":\"medium\"} -->\n<h2 class=\"has-text-align-center has-medium-font-size\" style=\"line-height:1.3\">Superb quality and attention to detail within the themes, but without a doubt some of the best customer service I have experienced with an online web design service.</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"50px\"} -->\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":771,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://block-patterns.s3.eu-west-1.amazonaws.com/images/Ellipse-5.png\" alt=\"\" class=\"wp-image-771\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"fontSize\":\"regular\"} -->\n<h2 class=\"has-text-align-center has-regular-font-size\">Esther Howard</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"typography\":{\"lineHeight\":\"0.2\",\"fontSize\":\"12px\",\"textTransform\":\"uppercase\",\"fontStyle\":\"normal\",\"fontWeight\":\"500\"},\"color\":{\"text\":\"#989191\"}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#989191;font-size:12px;font-style:normal;font-weight:500;line-height:0.2;text-transform:uppercase\">Managing Director</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"150px\"} -->\n<div style=\"height:150px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->",
		)
	);

	// Gallery
	register_block_pattern(
		'tk/gallery-1',
		array(
			'title'       => __( 'Four columns gallery1', 'furnizo' ),
			'description' => esc_html_x( 'Gallery pattern with a large title and four columns. ', 'Block pattern description', 'furnizo' ),
			'viewportWidth' => 1920,
			'categories' => array('tk-gallery'),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"backgroundColor\":\"background\",\"className\":\"l-no-margin-top\",\"layout\":{\"inherit\":true}} -->\n<div class=\"wp-block-group alignfull l-no-margin-top has-background-background-color has-background\"><!-- wp:spacer {\"height\":\"120px\"} -->\n<div style=\"height:120px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\"} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:heading {\"fontSize\":\"larger\"} -->\n<h2 class=\"has-larger-font-size\">Creating A<br>Stunning Gallery</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"10px\"} -->\n<div style=\"height:10px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"width\":\"33%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:33%\"><!-- wp:paragraph {\"style\":{\"typography\":{\"lineHeight\":\"1.4\"}},\"fontSize\":\"tiny\"} -->\n<p class=\"has-tiny-font-size\" style=\"line-height:1.4\">Galleries often choose to represent artists exclusively, giving them the opportunity to show regularly. Some have a narrow focus while others are more eclectic.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer -->\n<div style=\"height:100px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"5vw\",\"left\":\"5vw\"}}}} -->\n<div class=\"wp-block-group alignfull\" style=\"padding-right:5vw;padding-left:5vw\"><!-- wp:columns {\"align\":\"full\"} -->\n<div class=\"wp-block-columns alignfull\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":827,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://block-patterns.s3.eu-west-1.amazonaws.com/images/Rectangle-39.png\" alt=\"\" class=\"wp-image-827\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":828,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://block-patterns.s3.eu-west-1.amazonaws.com/images/Rectangle-40-1.png\" alt=\"\" class=\"wp-image-828\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":829,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://block-patterns.s3.eu-west-1.amazonaws.com/images/Rectangle-40.png\" alt=\"\" class=\"wp-image-829\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":830,\"sizeSlug\":\"full\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-full\"><img src=\"https://block-patterns.s3.eu-west-1.amazonaws.com/images/Rectangle-41.png\" alt=\"\" class=\"wp-image-830\"/></figure>\n<!-- /wp:image --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"150px\"} -->\n<div style=\"height:150px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group --></div>\n<!-- /wp:group -->",
		)
	);

	// Headers
	register_block_pattern(
		'tk/headers-1',
		array(
			'title'       => __( 'Full-screen header pattern with headline, text, and button', 'furnizo' ),
			'description' => esc_html_x( 'A full-screen header with headline, text, and a button on the left.', 'Block pattern description', 'furnizo' ),
			'viewportWidth' => 1920,
			'categories' => array('tk-headers'),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"layout\":{\"inherit\":true}} -->\n<div class=\"wp-block-group alignfull\"><!-- wp:cover {\"url\":\"https://block-patterns.s3.eu-west-1.amazonaws.com/images/hed1.jpg\",\"id\":277,\"dimRatio\":0,\"minHeight\":100,\"minHeightUnit\":\"vh\",\"contentPosition\":\"center left\",\"align\":\"full\",\"style\":{\"spacing\":{\"padding\":{\"top\":\"4%\",\"right\":\"4%\",\"bottom\":\"5%\",\"left\":\"4%\"}}}} -->\n<div class=\"wp-block-cover alignfull has-custom-content-position is-position-center-left\" style=\"padding-top:4%;padding-right:4%;padding-bottom:5%;padding-left:4%;min-height:100vh\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-background-dim-0 has-background-dim\"></span><img class=\"wp-block-cover__image-background wp-image-277\" alt=\"\" src=\"https://block-patterns.s3.eu-west-1.amazonaws.com/images/hed1.jpg\" data-object-fit=\"cover\"/><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"style\":{\"typography\":{\"lineHeight\":\"1.2\"}},\"textColor\":\"background\",\"fontSize\":\"larger\"} -->\n<h2 class=\"has-background-color has-text-color has-larger-font-size\" style=\"line-height:1.2\">Redesign your world<br>in just a few clisks.</h2>\n<!-- /wp:heading -->\n\n<!-- wp:columns -->\n<div class=\"wp-block-columns\"><!-- wp:column {\"verticalAlignment\":\"bottom\",\"width\":\"45%\",\"style\":{\"spacing\":{\"padding\":{\"right\":\"8vw\"}}},\"textColor\":\"foreground\"} -->\n<div class=\"wp-block-column is-vertically-aligned-bottom has-foreground-color has-text-color\" style=\"padding-right:8vw;flex-basis:45%\"><!-- wp:paragraph {\"style\":{\"color\":{\"text\":\"#ffffff9c\"}},\"fontSize\":\"small\"} -->\n<p class=\"has-text-color has-small-font-size\" style=\"color:#ffffff9c\">Though not required by the syntax of any language, paragraphs are usually an expected part of formal writing, used to organize longer&nbsp;prose.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"width\":\"50%\"} -->\n<div class=\"wp-block-column\" style=\"flex-basis:50%\"></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"60px\"} -->\n<div style=\"height:60px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:buttons -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"backgroundColor\":\"background\",\"textColor\":\"foreground\",\"style\":{\"border\":{\"radius\":\"100px\"}},\"fontSize\":\"regular\",\"fontFamily\":\"krylon\"} -->\n<div class=\"wp-block-button has-custom-font-size has-krylon-font-family has-regular-font-size\"><a class=\"wp-block-button__link has-foreground-color has-background-background-color has-text-color has-background wp-element-button\" style=\"border-radius:100px\">Get Started</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div></div>\n<!-- /wp:cover --></div>\n<!-- /wp:group -->",
		)
	);

	// Call to action
	register_block_pattern(
		'tk/call-to-action-1',
		array(
			'title'       => __( 'Call to action pattern with a headline and two buttons', 'furnizo' ),
			'description' => esc_html_x( 'CTA pattern with large heading and two buttons. ', 'Block pattern description', 'furnizo' ),
			'viewportWidth' => 1920,
			'categories' => array('tk-call-to-action'),
			'content'     => "<!-- wp:group {\"align\":\"full\",\"backgroundColor\":\"background\",\"layout\":{\"inherit\":true}} -->\n<div class=\"wp-block-group alignfull has-background-background-color has-background\"><!-- wp:spacer {\"height\":\"200px\"} -->\n<div style=\"height:200px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:group {\"align\":\"wide\",\"layout\":{\"contentSize\":\"1000px\"}} -->\n<div class=\"wp-block-group alignwide\"><!-- wp:heading {\"textAlign\":\"center\",\"textColor\":\"foreground\",\"fontSize\":\"extra-large\"} -->\n<h2 class=\"has-text-align-center has-foreground-color has-text-color has-extra-large-font-size\">A call to action (CTA) is an instruction to the audience designed to provoke an immediate response.</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"40px\"} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:separator {\"style\":{\"color\":{\"background\":\"#00000012\"}},\"className\":\"is-style-default\"} -->\n<hr class=\"wp-block-separator has-text-color has-alpha-channel-opacity has-background is-style-default\" style=\"background-color:#00000012;color:#00000012\"/>\n<!-- /wp:separator -->\n\n<!-- wp:spacer {\"height\":\"20px\"} -->\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:buttons {\"layout\":{\"type\":\"flex\",\"justifyContent\":\"center\",\"orientation\":\"horizontal\"}} -->\n<div class=\"wp-block-buttons\"><!-- wp:button {\"style\":{\"border\":{\"radius\":\"100px\"}},\"className\":\"is-style-outline\",\"fontSize\":\"regular\",\"fontFamily\":\"krylon\"} -->\n<div class=\"wp-block-button has-custom-font-size is-style-outline has-krylon-font-family has-regular-font-size\"><a class=\"wp-block-button__link wp-element-button\" style=\"border-radius:100px\">Find Out More</a></div>\n<!-- /wp:button -->\n\n<!-- wp:button {\"style\":{\"border\":{\"radius\":\"100px\"}},\"fontSize\":\"regular\",\"fontFamily\":\"krylon\"} -->\n<div class=\"wp-block-button has-custom-font-size has-krylon-font-family has-regular-font-size\"><a class=\"wp-block-button__link wp-element-button\" style=\"border-radius:100px\">Get Started</a></div>\n<!-- /wp:button --></div>\n<!-- /wp:buttons --></div>\n<!-- /wp:group -->\n\n<!-- wp:spacer {\"height\":\"200px\"} -->\n<div style=\"height:200px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:group -->",
		)
	);
	 
}
